/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.jobs.JobHealer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class CitizenDiseaseHandler
implements ICitizenDiseaseHandler {
    public static final double SEEK_DOCTOR_HEALTH = 6.0;
    private static final int DISEASE_FACTOR = 10000;
    private static final int IMMUNITY_TIME = 4200;
    private final AbstractEntityCitizen citizen;
    private String disease = "";
    private int immunityTicks = 0;
    private static final int initialCitizenCount = (Integer)IMinecoloniesAPI.getInstance().getConfig().getServer().initialCitizenAmount.get();

    public CitizenDiseaseHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void tick() {
        if (this.canBecomeSick()) {
            int citizenModifier = this.citizen.getCitizenJobHandler().getColonyJob() == null ? 1 : this.citizen.getCitizenJobHandler().getColonyJob().getDiseaseModifier();
            int configModifier = (Integer)MineColonies.getConfig().getServer().diseaseModifier.get();
            if (!IColonyManager.getInstance().getCompatibilityManager().getDiseases().isEmpty() && this.citizen.m_21187_().nextInt(configModifier * 10000) < citizenModifier) {
                this.disease = IColonyManager.getInstance().getCompatibilityManager().getRandomDisease();
            }
        }
        if (this.immunityTicks > 0) {
            --this.immunityTicks;
        }
    }

    private boolean canBecomeSick() {
        return !this.isSick() && this.citizen.getCitizenColonyHandler().getColony() != null && this.citizen.getCitizenColonyHandler().getColony().isActive() && !(this.citizen.getCitizenJobHandler().getColonyJob() instanceof JobHealer) && this.immunityTicks <= 0 && this.citizen.getCitizenColonyHandler().getColony().getCitizenManager().getCurrentCitizenCount() > initialCitizenCount;
    }

    @Override
    public void onCollission(@NotNull AbstractEntityCitizen citizen) {
        if (citizen.getCitizenDiseaseHandler().isSick() && this.canBecomeSick() && citizen.m_21187_().nextInt(100) < 1) {
            this.disease = citizen.getCitizenDiseaseHandler().getDisease();
        }
    }

    @Override
    public boolean isSick() {
        return !this.disease.isEmpty();
    }

    @Override
    public void write(CompoundTag compound) {
        compound.m_128359_("disease", this.disease);
        compound.m_128405_("immunity", this.immunityTicks);
    }

    @Override
    public void read(CompoundTag compound) {
        if (IColonyManager.getInstance().getCompatibilityManager().getDisease(compound.m_128461_("disease")) != null) {
            this.disease = compound.m_128461_("disease");
        }
        this.immunityTicks = compound.m_128451_("immunity");
    }

    @Override
    public String getDisease() {
        return this.disease;
    }

    @Override
    public void cure() {
        this.disease = "";
        if (this.citizen.getCitizenSleepHandler().isAsleep()) {
            this.citizen.m_5796_();
            BlockPos hospitalPos = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBestBuilding(this.citizen, BuildingCook.class);
            IColony colony = this.citizen.getCitizenColonyHandler().getColony();
            IBuilding hospital = colony.getBuildingManager().getBuilding(hospitalPos);
            if (hospital != null) {
                hospital.onWakeUp();
            }
            this.immunityTicks = 4200;
        }
    }
}

